uniform sampler2D Texture0;
varying vec2 texCoord;
uniform float viewportWidth;
uniform float viewportHeight;
uniform float contrast;
uniform float brightness;

void main(void)
{
   float scalex = 1.0/viewportWidth;
   float scaley = 1.0/viewportHeight;
   vec4 sum;
   sum = ((texture2D( Texture0, clamp(vec2(texCoord.x - scalex, texCoord.y + scaley), 0.0, 1.0)))-0.5+brightness)*contrast+0.5;
   sum += ((texture2D( Texture0, clamp(vec2(texCoord.x + scalex, texCoord.y + scaley), 0.0, 1.0)))-0.5+brightness)*contrast+0.5;
   sum += ((texture2D( Texture0, clamp(vec2(texCoord.x + scalex, texCoord.y - scaley), 0.0, 1.0)))-0.5+brightness)*contrast+0.5;
   sum += ((texture2D( Texture0, clamp(vec2(texCoord.x - scalex, texCoord.y - scaley), 0.0, 1.0)))-0.5+brightness)*contrast+0.5;
   gl_FragColor = sum / 4.0;
}
